;car structure: (IX)

SP_COLOR	EQU	0	; 0 color		;color xor 3
SP_MAPX		EQU	1	; 1 mapx		;X map position 
SP_MAPY		EQU	2	; 2 mapy		;Y map position
SP_INTRAX	EQU	3	; 3 intrax		;X char inside the tile
SP_INTRAY	EQU	4	; 4 intray		;Y char inside the tile
SP_SUBX		EQU	5	; 5 subx		;X position avance variable
SP_SUBY		EQU	6	; 6 suby		;Y position avance variable
SP_CAMERA	EQU	7	; 7 camera		;FIXED: ID
SP_FRAME	EQU	8	; 8 frame		;current frame
SP_GRAPH	EQU	9	; 9,10 graph		;points to the graphic in current frame
SP_SPEED	EQU	11	;11 speed		;current speed
SP_SUBSPEED	EQU	12	;12 subspeed		;accelaration advance variable
SP_STATE	EQU	13	;13 state		;current state
SP_CONTROL	EQU	14	;14,15 control		;control routine
SP_SUBGIRO	EQU	16	;16 subgiro		;turn advance variable
SP_MINIMAPX	EQU	17	;17 minimapx		;X of last pixel placed in the minimap
SP_MINIMAPY	EQU	18	;18 minimapy		;Y of last pixel placed in the minimap
SP_NEXTCHECK	EQU	19	;19 nextcheck		;offset of next checkpoint to arrive
SP_LAPS		EQU	20	;20 laps		;number of laps completed
SP_COL_DUR	EQU	21	;21 col_dur		;collision duration
SP_COL_DIR	EQU	22	;22 col_dir		;collision direction
SP_MAPPOINTS	EQU	23	;23 map points		;points won in current track when we finish
SP_DIRX		EQU	24	;24 dirx		;Speed X
SP_DIRY		EQU	25	;25 diry		;Speed Y
SP_IARAND1	EQU	26	;26 var1		;AI parameter 1
SP_IARAND2	EQU	27	;27 var2		;AI parameter 2
SP_IARAND3	EQU	28	;28 var3		;AI parameter 3
SP_ACCELRATE	EQU	29	;29 accelerate rate	;FIXED: how much subspeed is increased in acceleration
SP_TIMESTAMPCP	EQU	30	;30 timestamp checkpoint;last timestamp checkpoint
SP_TIMESTAMPLAP EQU	31	;31 timestamp lap	;last timestamp lap
SP_TIMESTAMP	EQU	32	;32,33 timestamp	;last timestamp, to compare with other cars
SP_LAPSTART	EQU	34	;34,35 lap start	;lap start timestamp
SP_BESTLAP	EQU	36	;36,37 best lap		;best lap time
SP_RELPOS	EQU	38	;38 relpos		;relative position in marker
SP_CONTOPT	EQU	39	;39 contoption		;control option
SP_POINTS	EQU	40	;40 puntos		;points accumulated in current championship
SP_MASTCOL	EQU	41	;41 master color	;FIXED: master color, to copy into color when we're not in DON'T RACE
SP_NOVICE	EQU	42	;42 novice		;points to the high byte of map checkpoint table for this car
SP_LASTCONTROL	EQU	43	;43 last control	;last 4 bits control code, for recordings
SP_CONTROLBAK	EQU	44	;44,45 control backup	;control routine copy

;camera structure: (IY)
				;0-17 graphs		; tiles buffer
CAM_CAR		EQU	18	;18 car			;  0 to  3, VARIABLE -> id of the car this camera is following
CAM_MAPX	EQU	19	;19 mapx		;  0 to 63, VARIABLE -> X map position
CAM_MAPY	EQU	20	;20 mapy		;  0 to 63, VARIABLE -> Y map position
CAM_INTRAX	EQU	21	;21 intrax		; -7 to  0, VARIABLE -> X offset in characters
CAM_INTRAY	EQU	22	;22 intray		; -7 to  0, VARIABLE -> Y offset in characters
CAM_POSX	EQU	23	;23 posx		; X position of car relative to camera
CAM_POSY	EQU	24	;24 posy		; Y position of car relative to camera
CAM_BUFFERPOS	EQU	25	;25-26 bufferpos	; Buffer position in the upper left corner
CAM_MARCADORAT	EQU	27	;27-28 marker attributes; FIXED: Points to marker attributes
CAM_MARCADORGR	EQU	29	;29-30 marker graphics	; FIXED: Points to marker graphics
CAM_MESSLAP	EQU	31	;31-32 lap message	; FIXED: Points to lap numbers message
CAM_ID		EQU	33	;33 id			; FIXED: camera identificator
CAM_MESSTIME	EQU	34	;34-40 time message	; FIXED/VARIABLE: Current lap time message
CAM_NUMMINDEC	EQU	36	; 35 minute tens	; tens of minutes for current lap
CAM_NUMMINUNI	EQU	37	; 36 minute units	; units of minutes for current lap
CAM_NUMSEGDEC	EQU	38	; 37 second tens	; tens of seconds for current lap
CAM_NUMSEGUNI	EQU	39	; 39 second units	; units of senconds for current lap